/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;

public class MagneticFieldWireAP
extends AP6
implements MouseListener,
MouseMotionListener {
    static final String[][] text = new String[][]{{"de", "Magnetfeld eines geraden stromdurchflossenen Leiters", "Umpolen", ""}, {"en", "Magnetic Field of a Straight Current-Carrying Wire", "Reverse current", ""}};
    private int[] gaps = new int[]{20, 200, 0, 20};
    final int width = 600;
    final int height = 400;
    final int width0 = 400;
    FontMetrics fmH;
    CanvasAP cv;
    Panel6 pan;
    JButton buDir;
    Color bgCanvas;
    Color bgPanel;
    Color colorButton;
    Color colorBase;
    Color colorPlus;
    Color colorMinus;
    Color colorWire;
    Color colorElectron;
    Color colorCurrent;
    Color colorNeedle;
    Color colorNorth;
    Color colorSouth;
    Color colorField;
    String coauthor;
    String text01;
    final double theta = 0.3490658503988659;
    final double phi = 2.792526803190927;
    final double sinTh = Math.sin(0.3490658503988659);
    double t;
    int xU;
    int yU;
    double a1;
    double a2;
    double b1;
    double b2;
    double b3;
    double c1;
    double c2;
    double c3;
    int dir;
    double[] needleNx;
    double[] needleNy;
    double[] needleSx;
    double[] needleSy;
    double x;
    double y;
    double u;
    double v;
    boolean near;
    boolean drag;
    double dvMouse;
    int nEl;
    int[] uEl;
    int[] vEl;

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 400);
    }

    @Override
    protected void initAttributes() {
        this.xU = 200;
        this.yU = 200;
        this.dir = 1;
        this.x = 0.0;
        this.y = 100.0;
        this.drag = false;
        this.calcCoeff();
        this.u = this.coordsU(this.x, this.y);
        this.v = this.coordsV(this.x, this.y, 0.0);
        this.needleNx = new double[3];
        this.needleNy = new double[3];
        this.needleSx = new double[3];
        this.needleSy = new double[3];
        this.initElectrons();
    }

    @Override
    protected void initColors() {
        this.bgCanvas = this.getColor(Color.yellow, "bgCanvas");
        this.bgPanel = this.getColor(Color.green, "bgPanel");
        this.colorBase = this.getColor(Color.orange, "colorBase");
        this.colorButton = this.getColor(new Color(255, 64, 64), "colorButton");
        this.colorPlus = this.getColor(Color.red, "colorPlus");
        this.colorMinus = this.getColor(Color.blue, "colorMinus");
        this.colorWire = this.getColor(Color.cyan, "colorWire");
        this.colorElectron = this.getColor(new Color(0, 128, 32), "colorElectron");
        this.colorCurrent = this.getColor(Color.red, "colorCurrent");
        this.colorNeedle = this.getColor(Color.magenta, "colorNeedle");
        this.colorNorth = this.getColor(Color.red, "colorNorth");
        this.colorSouth = this.getColor(Color.green, "colorSouth");
        this.colorField = this.getColor(Color.blue, "colorField");
    }

    @Override
    protected void initText() {
        String[] t = this.searchLanguage(text, "en");
        this.language = this.getText(this.language, "language");
        this.title = this.getText(t[1], "title");
        this.text01 = this.getText(t[2], "text01");
        this.coauthor = this.getText(t[3], "coauthor");
    }

    @Override
    protected void initCanvas() {
        this.cv = new CanvasAP(this);
        this.cv.setBounds(0, 0, 400, 400);
        this.add(this.cv);
        this.cv.addMouseListener(this);
        this.cv.addMouseMotionListener(this);
    }

    @Override
    protected void initPanel() {
        this.pan = new Panel6(this, this.bgPanel, 1, this.gaps);
        this.pan.setBounds(400, 0, 200, 400);
        this.buDir = this.pan.newButton(this.text01, this.colorButton);
        this.pan.add(2000);
        this.pan.add(this.coauthor);
        this.add(this.pan);
    }

    @Override
    public void run() {
        long t0 = System.currentTimeMillis();
        while (this.thr == Thread.currentThread()) {
            this.cv.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            long t1 = System.currentTimeMillis();
            this.t += (double)(t1 - t0) / 1000.0;
            long n = (long)(this.t / 10.0);
            this.t -= (double)(n * 10L);
            t0 = t1;
        }
    }

    void calcCoeff() {
        double cos = Math.cos(0.3490658503988659);
        this.a1 = Math.sin(2.792526803190927);
        this.a2 = -Math.cos(2.792526803190927);
        this.b1 = -this.sinTh * this.a2;
        this.b2 = this.sinTh * this.a1;
        this.b3 = cos;
        this.c1 = -cos * this.a2;
        this.c2 = cos * this.a1;
        this.c3 = -this.sinTh;
    }

    double coordsU(double x, double y) {
        return (double)this.xU + this.a1 * x + this.a2 * y;
    }

    double coordsV(double x, double y, double z) {
        return (double)this.yU + this.b1 * x + this.b2 * y + this.b3 * z;
    }

    void setPoint(double[] px, double[] py, int i, double x, double y) {
        px[i] = this.coordsU(x, y);
        py[i] = this.coordsV(x, y, 0.0);
    }

    void updatePolygons() {
        double alpha = Math.atan2(this.y, this.x);
        double sin = Math.sin(alpha);
        double cos = Math.cos(alpha);
        double dx1 = (double)(this.dir * 50) * sin;
        double dy1 = (double)(-this.dir * 50) * cos;
        double dx2 = (double)(this.dir * 10) * cos;
        double dy2 = (double)(this.dir * 10) * sin;
        this.setPoint(this.needleNx, this.needleNy, 0, this.x + dx1, this.y + dy1);
        this.setPoint(this.needleNx, this.needleNy, 1, this.x + dx2, this.y + dy2);
        this.setPoint(this.needleNx, this.needleNy, 2, this.x - dx2, this.y - dy2);
        this.setPoint(this.needleSx, this.needleSy, 0, this.x - dx1, this.y - dy1);
        this.setPoint(this.needleSx, this.needleSy, 1, this.x - dx2, this.y - dy2);
        this.setPoint(this.needleSx, this.needleSy, 2, this.x + dx2, this.y + dy2);
    }

    void initElectrons() {
        int l = (int)(4.0 * ((this.coordsV(0.0, 0.0, 150.0) - this.coordsV(0.0, 0.0, -150.0)) / 4.0));
        this.nEl = l + 4;
        this.uEl = new int[this.nEl];
        this.vEl = new int[this.nEl];
        for (int i = 0; i < this.nEl; ++i) {
            int rn1 = (int)(3.0 * Math.random()) - 1;
            int rn2 = (int)(3.0 * Math.random()) - 1;
            this.uEl[i] = this.xU - 6 + 4 * (i % 4) + rn1;
            this.vEl[i] = 4 * (i / 4) + rn2;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.dir = -this.dir;
    }

    @Override
    public void mousePressed(MouseEvent me) {
        int uNew = me.getX();
        int vNew = me.getY();
        if (Math.abs((double)uNew - this.u) <= 10.0 && (double)vNew >= this.v + 5.0 && (double)vNew <= this.v + 35.0) {
            this.drag = true;
            this.dvMouse = (double)vNew - this.v;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.drag = false;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.drag) {
            return;
        }
        this.u = me.getX();
        this.v = (double)me.getY() - this.dvMouse;
        double det = this.a1 * this.b2 - this.b1 * this.a2;
        double r1 = this.u - (double)this.xU;
        double r2 = this.v - (double)this.yU;
        this.x = (r1 * this.b2 - r2 * this.a2) / det;
        this.y = (this.a1 * r2 - this.b1 * r1) / det;
        double rad = Math.sqrt(this.x * this.x + this.y * this.y);
        double f = 1.0;
        if (rad == 0.0) {
            rad = 30.0;
            this.x = 30.0;
        }
        if (rad < 30.0) {
            f = 30.0 / rad;
        }
        if (rad > 130.0) {
            f = 130.0 / rad;
        }
        if (rad < 30.0 || rad > 130.0) {
            this.x *= f;
            this.y *= f;
            this.u = this.coordsU(this.x, this.y);
            this.v = this.coordsV(this.x, this.y, 0.0);
        }
        this.cv.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    class CanvasAP
    extends Canvas6 {
        CanvasAP(AP6 ap) {
            super(ap, MagneticFieldWireAP.this.bgCanvas);
            MagneticFieldWireAP.this.fmH = this.getFontMetrics(this.fH);
        }

        void cylinder(Graphics2D g, double x, double y, double z, double r, double h, Color c) {
            double a = r;
            double b = r * MagneticFieldWireAP.this.sinTh;
            double u = MagneticFieldWireAP.this.coordsU(x, y);
            double vLow = MagneticFieldWireAP.this.coordsV(x, y, z);
            double vHigh = MagneticFieldWireAP.this.coordsV(x, y, z - h);
            double uL = u - a;
            double uR = u + a;
            CanvasAP.rectangle(g, uL, vHigh, 2.0 * a, vLow - vHigh, c);
            CanvasAP.ellipse(g, u, vHigh, a, b, c);
            CanvasAP.ellipse(g, u, vLow, a, b, c);
            CanvasAP.ellipse(g, u, vHigh, a, b, Color.black, false);
            g.setColor(Color.black);
            CanvasAP.ellArc(g, u, vLow, a, b, Math.PI, Math.PI);
            CanvasAP.line(g, uL, vLow, uL, vHigh);
            CanvasAP.line(g, uR, vLow, uR, vHigh);
        }

        void magNeedle(Graphics2D g) {
            this.cylinder(g, MagneticFieldWireAP.this.x, MagneticFieldWireAP.this.y, 30.0, 20.0, 5.0, MagneticFieldWireAP.this.colorNeedle);
            this.cylinder(g, MagneticFieldWireAP.this.x, MagneticFieldWireAP.this.y, 25.0, 2.0, 16.0, MagneticFieldWireAP.this.colorNeedle);
            double v0 = MagneticFieldWireAP.this.coordsV(MagneticFieldWireAP.this.x, MagneticFieldWireAP.this.y, 10.0);
            g.setColor(Color.black);
            CanvasAP.line(g, MagneticFieldWireAP.this.u, MagneticFieldWireAP.this.v, MagneticFieldWireAP.this.u, v0);
            MagneticFieldWireAP.this.updatePolygons();
            CanvasAP.polygon(g, MagneticFieldWireAP.this.needleNx, MagneticFieldWireAP.this.needleNy, MagneticFieldWireAP.this.colorNorth, true);
            CanvasAP.polygon(g, MagneticFieldWireAP.this.needleSx, MagneticFieldWireAP.this.needleSy, MagneticFieldWireAP.this.colorSouth, true);
            CanvasAP.circle(g, MagneticFieldWireAP.this.u, MagneticFieldWireAP.this.v, 2.5, Color.black);
        }

        void electrons(Graphics2D g, boolean low) {
            double v0 = MagneticFieldWireAP.this.coordsV(0.0, 0.0, -150.0);
            double vHigh = MagneticFieldWireAP.this.coordsV(0.0, 0.0, low ? 40.0 : -150.0);
            double vLow = MagneticFieldWireAP.this.coordsV(0.0, 0.0, low ? 150.0 : 30.0);
            int l = MagneticFieldWireAP.this.nEl - 4;
            int dv = (int)((double)l * MagneticFieldWireAP.this.t / 10.0);
            if (MagneticFieldWireAP.this.dir < 0) {
                dv = l - dv;
            }
            g.setColor(MagneticFieldWireAP.this.colorElectron);
            for (int i = 0; i < MagneticFieldWireAP.this.nEl; ++i) {
                boolean cond;
                double v = v0 + (double)((MagneticFieldWireAP.this.vEl[i] + dv) % l);
                boolean bl = low ? v < vHigh : (cond = v > vLow);
                if (cond) continue;
                CanvasAP.line(g, MagneticFieldWireAP.this.uEl[i], v, MagneticFieldWireAP.this.uEl[i], v);
            }
        }

        void wire1(Graphics2D g) {
            this.cylinder(g, 0.0, 0.0, 150.0, 10.0, 110.0, MagneticFieldWireAP.this.colorWire);
            double vLow = MagneticFieldWireAP.this.coordsV(0.0, 0.0, 150.0);
            this.electrons(g, true);
            Color c = MagneticFieldWireAP.this.dir > 0 ? MagneticFieldWireAP.this.colorPlus : MagneticFieldWireAP.this.colorMinus;
            CanvasAP.rectangle(g, MagneticFieldWireAP.this.xU + 20, vLow - 21.0, 11.0, 3.0, c);
            if (MagneticFieldWireAP.this.dir > 0) {
                CanvasAP.rectangle(g, MagneticFieldWireAP.this.xU + 24, vLow - 25.0, 3.0, 11.0, c);
            }
        }

        void wire2(Graphics2D g) {
            this.cylinder(g, 0.0, 0.0, 30.0, 10.0, 180.0, MagneticFieldWireAP.this.colorWire);
            double vHigh = MagneticFieldWireAP.this.coordsV(0.0, 0.0, -150.0);
            this.electrons(g, false);
            Color c = MagneticFieldWireAP.this.dir > 0 ? MagneticFieldWireAP.this.colorMinus : MagneticFieldWireAP.this.colorPlus;
            CanvasAP.rectangle(g, MagneticFieldWireAP.this.xU + 20, vHigh + 19.0, 11.0, 3.0, c);
            if (MagneticFieldWireAP.this.dir < 0) {
                CanvasAP.rectangle(g, MagneticFieldWireAP.this.xU + 24, vHigh + 15.0, 3.0, 11.0, c);
            }
            g.setColor(MagneticFieldWireAP.this.colorCurrent);
            CanvasAP.arrow(g, 3.0, MagneticFieldWireAP.this.xU, MagneticFieldWireAP.this.yU - 50 + MagneticFieldWireAP.this.dir * 10, MagneticFieldWireAP.this.xU, MagneticFieldWireAP.this.yU - 50 - MagneticFieldWireAP.this.dir * 10);
        }

        void mfLine(Graphics2D g, double z, double r, boolean near) {
            double v = MagneticFieldWireAP.this.coordsV(0.0, 0.0, z);
            double a = r;
            double b = r * MagneticFieldWireAP.this.sinTh;
            g.setColor(MagneticFieldWireAP.this.colorField);
            double w0 = near ? Math.PI : 0.0;
            CanvasAP.ellArc(g, 2.0, MagneticFieldWireAP.this.xU, v, a, b, w0, Math.PI);
            double w = 0.5235987755982988;
            double u0 = (double)MagneticFieldWireAP.this.xU + a * Math.cos(w);
            double v0 = v - b * Math.sin(w);
            if (!near) {
                CanvasAP.arrow(g, 2.0, u0 + (double)(MagneticFieldWireAP.this.dir * 3), v0 + (double)(MagneticFieldWireAP.this.dir * 2), u0 - (double)(MagneticFieldWireAP.this.dir * 3), v0 - (double)(MagneticFieldWireAP.this.dir * 2));
            }
            u0 = (double)(2 * MagneticFieldWireAP.this.xU) - u0;
            v0 = 2.0 * v - v0;
            if (near) {
                CanvasAP.arrow(g, 2.0, u0 - (double)(MagneticFieldWireAP.this.dir * 3), v0 - (double)(MagneticFieldWireAP.this.dir * 2), u0 + (double)(MagneticFieldWireAP.this.dir * 3), v0 + (double)(MagneticFieldWireAP.this.dir * 2));
            }
        }

        void mfLines(Graphics2D g, boolean near) {
            this.mfLine(g, -60.0, 30.0, near);
            this.mfLine(g, -60.0, 60.0, near);
            this.mfLine(g, -60.0, 120.0, near);
            this.mfLine(g, 0.0, Math.sqrt(MagneticFieldWireAP.this.x * MagneticFieldWireAP.this.x + MagneticFieldWireAP.this.y * MagneticFieldWireAP.this.y), near);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2 = (Graphics2D)g;
            CanvasAP.setAntiAliasing(g2, true);
            this.wire1(g2);
            this.cylinder(g2, 0.0, 0.0, 40.0, 150.0, 10.0, MagneticFieldWireAP.this.colorBase);
            this.mfLines(g2, false);
            boolean bl = MagneticFieldWireAP.this.near = MagneticFieldWireAP.this.c1 * MagneticFieldWireAP.this.x + MagneticFieldWireAP.this.c2 * MagneticFieldWireAP.this.y >= 0.0;
            if (MagneticFieldWireAP.this.near) {
                this.wire2(g2);
                this.mfLines(g2, true);
                this.magNeedle(g2);
            } else {
                this.magNeedle(g2);
                this.wire2(g2);
                this.mfLines(g2, true);
            }
        }
    }
}

